<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\FlexApi\V1\Interaction\InteractionChannel;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class InteractionTransferContext extends InstanceContext
    {
    /**
     * Initialize the InteractionTransferContext
     *
     * @param Version $version Version that contains the resource
     * @param string $interactionSid The Interaction Sid for the Interaction
     * @param string $channelSid The Channel Sid for the Channel.
     * @param string $sid The unique string created by Twilio to identify a Transfer resource.
     */
    public function __construct(
        Version $version,
        $interactionSid,
        $channelSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'interactionSid' =>
            $interactionSid,
        'channelSid' =>
            $channelSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Interactions/' . \rawurlencode($interactionSid)
        .'/Channels/' . \rawurlencode($channelSid)
        .'/Transfers/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the InteractionTransferInstance
     *
     * @return InteractionTransferInstance Fetched InteractionTransferInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): InteractionTransferInstance
    {
        $response = $this->_fetch();
        return new InteractionTransferInstance(
            $this->version,
            $response->getContent(),
            $this->solution['interactionSid'],
            $this->solution['channelSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the InteractionTransferInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new InteractionTransferInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['interactionSid'],
                        $this->solution['channelSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $body->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the InteractionTransferInstance
     *
     * @return InteractionTransferInstance Updated InteractionTransferInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): InteractionTransferInstance
    {
        $response = $this->_update();
        return new InteractionTransferInstance(
            $this->version,
            $response->getContent(),
            $this->solution['interactionSid'],
            $this->solution['channelSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Update the InteractionTransferInstance with Metadata
     *
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(): ResourceMetadata
    {
        $response = $this->_update();
        $resource = new InteractionTransferInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['interactionSid'],
                        $this->solution['channelSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InteractionTransferContext ' . \implode(' ', $context) . ']';
    }
}
